package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{
  LabelKey,
  TagValue,
  BoxedInteger,
  LabelValue,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateNodegroupRequest(
    clusterName: String,
    nodegroupName: String,
    scalingConfig: Optional[zio.aws.eks.model.NodegroupScalingConfig] =
      Optional.Absent,
    diskSize: Optional[BoxedInteger] = Optional.Absent,
    subnets: Iterable[String],
    instanceTypes: Optional[Iterable[String]] = Optional.Absent,
    amiType: Optional[zio.aws.eks.model.AMITypes] = Optional.Absent,
    remoteAccess: Optional[zio.aws.eks.model.RemoteAccessConfig] =
      Optional.Absent,
    nodeRole: String,
    labels: Optional[Map[LabelKey, LabelValue]] = Optional.Absent,
    taints: Optional[Iterable[zio.aws.eks.model.Taint]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientRequestToken: Optional[String] = Optional.Absent,
    launchTemplate: Optional[zio.aws.eks.model.LaunchTemplateSpecification] =
      Optional.Absent,
    updateConfig: Optional[zio.aws.eks.model.NodegroupUpdateConfig] =
      Optional.Absent,
    capacityType: Optional[zio.aws.eks.model.CapacityTypes] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    releaseVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateNodegroupRequest = {
    import CreateNodegroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodegroupName(nodegroupName: java.lang.String)
      .optionallyWith(scalingConfig.map(value => value.buildAwsValue()))(
        _.scalingConfig
      )
      .optionallyWith(diskSize.map(value => value: Integer))(_.diskSize)
      .subnets(subnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(amiType.map(value => value.unwrap))(_.amiType)
      .optionallyWith(remoteAccess.map(value => value.buildAwsValue()))(
        _.remoteAccess
      )
      .nodeRole(nodeRole: java.lang.String)
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (LabelKey.unwrap(key): java.lang.String) -> (LabelValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .optionallyWith(
        taints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taints)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(updateConfig.map(value => value.buildAwsValue()))(
        _.updateConfig
      )
      .optionallyWith(capacityType.map(value => value.unwrap))(_.capacityType)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(releaseVersion.map(value => value: java.lang.String))(
        _.releaseVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateNodegroupRequest.ReadOnly =
    zio.aws.eks.model.CreateNodegroupRequest.wrap(buildAwsValue())
}
object CreateNodegroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateNodegroupRequest =
      zio.aws.eks.model.CreateNodegroupRequest(
        clusterName,
        nodegroupName,
        scalingConfig.map(value => value.asEditable),
        diskSize.map(value => value),
        subnets,
        instanceTypes.map(value => value),
        amiType.map(value => value),
        remoteAccess.map(value => value.asEditable),
        nodeRole,
        labels.map(value => value),
        taints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        clientRequestToken.map(value => value),
        launchTemplate.map(value => value.asEditable),
        updateConfig.map(value => value.asEditable),
        capacityType.map(value => value),
        version.map(value => value),
        releaseVersion.map(value => value)
      )
    def clusterName: String
    def nodegroupName: String
    def scalingConfig
        : Optional[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly]
    def diskSize: Optional[BoxedInteger]
    def subnets: List[String]
    def instanceTypes: Optional[List[String]]
    def amiType: Optional[zio.aws.eks.model.AMITypes]
    def remoteAccess: Optional[zio.aws.eks.model.RemoteAccessConfig.ReadOnly]
    def nodeRole: String
    def labels: Optional[Map[LabelKey, LabelValue]]
    def taints: Optional[List[zio.aws.eks.model.Taint.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientRequestToken: Optional[String]
    def launchTemplate
        : Optional[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly]
    def updateConfig: Optional[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly]
    def capacityType: Optional[zio.aws.eks.model.CapacityTypes]
    def version: Optional[String]
    def releaseVersion: Optional[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodegroupName: ZIO[Any, Nothing, String] = ZIO.succeed(nodegroupName)
    def getScalingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.NodegroupScalingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("scalingConfig", scalingConfig)
    def getDiskSize: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("diskSize", diskSize)
    def getSubnets: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnets)
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getAmiType: ZIO[Any, AwsError, zio.aws.eks.model.AMITypes] =
      AwsError.unwrapOptionField("amiType", amiType)
    def getRemoteAccess
        : ZIO[Any, AwsError, zio.aws.eks.model.RemoteAccessConfig.ReadOnly] =
      AwsError.unwrapOptionField("remoteAccess", remoteAccess)
    def getNodeRole: ZIO[Any, Nothing, String] = ZIO.succeed(nodeRole)
    def getLabels: ZIO[Any, AwsError, Map[LabelKey, LabelValue]] =
      AwsError.unwrapOptionField("labels", labels)
    def getTaints: ZIO[Any, AwsError, List[zio.aws.eks.model.Taint.ReadOnly]] =
      AwsError.unwrapOptionField("taints", taints)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getUpdateConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      AwsError.unwrapOptionField("updateConfig", updateConfig)
    def getCapacityType: ZIO[Any, AwsError, zio.aws.eks.model.CapacityTypes] =
      AwsError.unwrapOptionField("capacityType", capacityType)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getReleaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
  ) extends zio.aws.eks.model.CreateNodegroupRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodegroupName: String = impl.nodegroupName(): String
    override val scalingConfig
        : Optional[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfig())
        .map(value => zio.aws.eks.model.NodegroupScalingConfig.wrap(value))
    override val diskSize: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.diskSize())
      .map(value => value: BoxedInteger)
    override val subnets: List[String] = impl
      .subnets()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val instanceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val amiType: Optional[zio.aws.eks.model.AMITypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amiType())
        .map(value => zio.aws.eks.model.AMITypes.wrap(value))
    override val remoteAccess
        : Optional[zio.aws.eks.model.RemoteAccessConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccess())
        .map(value => zio.aws.eks.model.RemoteAccessConfig.wrap(value))
    override val nodeRole: String = impl.nodeRole(): String
    override val labels: Optional[Map[LabelKey, LabelValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eks.model.primitives
                .LabelKey(key) -> zio.aws.eks.model.primitives.LabelValue(value)
            })
            .toMap
        )
    override val taints: Optional[List[zio.aws.eks.model.Taint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.Taint.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
    override val launchTemplate
        : Optional[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplate())
        .map(value => zio.aws.eks.model.LaunchTemplateSpecification.wrap(value))
    override val updateConfig
        : Optional[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateConfig())
        .map(value => zio.aws.eks.model.NodegroupUpdateConfig.wrap(value))
    override val capacityType: Optional[zio.aws.eks.model.CapacityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityType())
        .map(value => zio.aws.eks.model.CapacityTypes.wrap(value))
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val releaseVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
  ): zio.aws.eks.model.CreateNodegroupRequest.ReadOnly = new Wrapper(impl)
}
