package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait AMITypes {
  def unwrap: software.amazon.awssdk.services.eks.model.AMITypes
}
object AMITypes {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.AMITypes
  ): zio.aws.eks.model.AMITypes = value match {
    case software.amazon.awssdk.services.eks.model.AMITypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.AL2_X86_64 =>
      val r = AL2_x86_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.AL2_X86_64_GPU =>
      val r = AL2_x86_64_GPU
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.AL2_ARM_64 =>
      val r = AL2_ARM_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_ARM_64 =>
      val r = BOTTLEROCKET_ARM_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_X86_64 =>
      val r = BOTTLEROCKET_x86_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_ARM_64_NVIDIA =>
      val r = BOTTLEROCKET_ARM_64_NVIDIA
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_X86_64_NVIDIA =>
      val r = BOTTLEROCKET_x86_64_NVIDIA
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_CORE_2019_X86_64 =>
      val r = WINDOWS_CORE_2019_x86_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_FULL_2019_X86_64 =>
      val r = WINDOWS_FULL_2019_x86_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_CORE_2022_X86_64 =>
      val r = WINDOWS_CORE_2022_x86_64
      r
    case software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_FULL_2022_X86_64 =>
      val r = WINDOWS_FULL_2022_x86_64
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.UNKNOWN_TO_SDK_VERSION
  }
  case object AL2_x86_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.AL2_X86_64
  }
  case object AL2_x86_64_GPU extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.AL2_X86_64_GPU
  }
  case object AL2_ARM_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.AL2_ARM_64
  }
  case object CUSTOM extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.CUSTOM
  }
  case object BOTTLEROCKET_ARM_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_ARM_64
  }
  case object BOTTLEROCKET_x86_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_X86_64
  }
  case object BOTTLEROCKET_ARM_64_NVIDIA extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_ARM_64_NVIDIA
  }
  case object BOTTLEROCKET_x86_64_NVIDIA extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.BOTTLEROCKET_X86_64_NVIDIA
  }
  case object WINDOWS_CORE_2019_x86_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_CORE_2019_X86_64
  }
  case object WINDOWS_FULL_2019_x86_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_FULL_2019_X86_64
  }
  case object WINDOWS_CORE_2022_x86_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_CORE_2022_X86_64
  }
  case object WINDOWS_FULL_2022_x86_64 extends zio.aws.eks.model.AMITypes {
    override def unwrap: software.amazon.awssdk.services.eks.model.AMITypes =
      software.amazon.awssdk.services.eks.model.AMITypes.WINDOWS_FULL_2022_X86_64
  }
}
