package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait TaintEffect {
  def unwrap: software.amazon.awssdk.services.eks.model.TaintEffect
}
object TaintEffect {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.TaintEffect
  ): zio.aws.eks.model.TaintEffect = value match {
    case software.amazon.awssdk.services.eks.model.TaintEffect.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.TaintEffect.NO_SCHEDULE =>
      val r = NO_SCHEDULE
      r
    case software.amazon.awssdk.services.eks.model.TaintEffect.NO_EXECUTE =>
      val r = NO_EXECUTE
      r
    case software.amazon.awssdk.services.eks.model.TaintEffect.PREFER_NO_SCHEDULE =>
      val r = PREFER_NO_SCHEDULE
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.TaintEffect {
    override def unwrap: software.amazon.awssdk.services.eks.model.TaintEffect =
      software.amazon.awssdk.services.eks.model.TaintEffect.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_SCHEDULE extends zio.aws.eks.model.TaintEffect {
    override def unwrap: software.amazon.awssdk.services.eks.model.TaintEffect =
      software.amazon.awssdk.services.eks.model.TaintEffect.NO_SCHEDULE
  }
  case object NO_EXECUTE extends zio.aws.eks.model.TaintEffect {
    override def unwrap: software.amazon.awssdk.services.eks.model.TaintEffect =
      software.amazon.awssdk.services.eks.model.TaintEffect.NO_EXECUTE
  }
  case object PREFER_NO_SCHEDULE extends zio.aws.eks.model.TaintEffect {
    override def unwrap: software.amazon.awssdk.services.eks.model.TaintEffect =
      software.amazon.awssdk.services.eks.model.TaintEffect.PREFER_NO_SCHEDULE
  }
}
