package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{RequiredClaimsValue, RequiredClaimsKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OidcIdentityProviderConfigRequest(
    identityProviderConfigName: String,
    issuerUrl: String,
    clientId: String,
    usernameClaim: Optional[String] = Optional.Absent,
    usernamePrefix: Optional[String] = Optional.Absent,
    groupsClaim: Optional[String] = Optional.Absent,
    groupsPrefix: Optional[String] = Optional.Absent,
    requiredClaims: Optional[Map[RequiredClaimsKey, RequiredClaimsValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfigRequest = {
    import OidcIdentityProviderConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfigRequest
      .builder()
      .identityProviderConfigName(identityProviderConfigName: java.lang.String)
      .issuerUrl(issuerUrl: java.lang.String)
      .clientId(clientId: java.lang.String)
      .optionallyWith(usernameClaim.map(value => value: java.lang.String))(
        _.usernameClaim
      )
      .optionallyWith(usernamePrefix.map(value => value: java.lang.String))(
        _.usernamePrefix
      )
      .optionallyWith(groupsClaim.map(value => value: java.lang.String))(
        _.groupsClaim
      )
      .optionallyWith(groupsPrefix.map(value => value: java.lang.String))(
        _.groupsPrefix
      )
      .optionallyWith(
        requiredClaims.map(value =>
          value
            .map({ case (key, value) =>
              (RequiredClaimsKey
                .unwrap(key): java.lang.String) -> (RequiredClaimsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.requiredClaims)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.OidcIdentityProviderConfigRequest.ReadOnly =
    zio.aws.eks.model.OidcIdentityProviderConfigRequest.wrap(buildAwsValue())
}
object OidcIdentityProviderConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.OidcIdentityProviderConfigRequest =
      zio.aws.eks.model.OidcIdentityProviderConfigRequest(
        identityProviderConfigName,
        issuerUrl,
        clientId,
        usernameClaim.map(value => value),
        usernamePrefix.map(value => value),
        groupsClaim.map(value => value),
        groupsPrefix.map(value => value),
        requiredClaims.map(value => value)
      )
    def identityProviderConfigName: String
    def issuerUrl: String
    def clientId: String
    def usernameClaim: Optional[String]
    def usernamePrefix: Optional[String]
    def groupsClaim: Optional[String]
    def groupsPrefix: Optional[String]
    def requiredClaims: Optional[Map[RequiredClaimsKey, RequiredClaimsValue]]
    def getIdentityProviderConfigName: ZIO[Any, Nothing, String] =
      ZIO.succeed(identityProviderConfigName)
    def getIssuerUrl: ZIO[Any, Nothing, String] = ZIO.succeed(issuerUrl)
    def getClientId: ZIO[Any, Nothing, String] = ZIO.succeed(clientId)
    def getUsernameClaim: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usernameClaim", usernameClaim)
    def getUsernamePrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usernamePrefix", usernamePrefix)
    def getGroupsClaim: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupsClaim", groupsClaim)
    def getGroupsPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupsPrefix", groupsPrefix)
    def getRequiredClaims
        : ZIO[Any, AwsError, Map[RequiredClaimsKey, RequiredClaimsValue]] =
      AwsError.unwrapOptionField("requiredClaims", requiredClaims)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfigRequest
  ) extends zio.aws.eks.model.OidcIdentityProviderConfigRequest.ReadOnly {
    override val identityProviderConfigName: String =
      impl.identityProviderConfigName(): String
    override val issuerUrl: String = impl.issuerUrl(): String
    override val clientId: String = impl.clientId(): String
    override val usernameClaim: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usernameClaim())
      .map(value => value: String)
    override val usernamePrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usernamePrefix())
      .map(value => value: String)
    override val groupsClaim: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupsClaim())
      .map(value => value: String)
    override val groupsPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupsPrefix())
      .map(value => value: String)
    override val requiredClaims
        : Optional[Map[RequiredClaimsKey, RequiredClaimsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredClaims())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eks.model.primitives.RequiredClaimsKey(
                key
              ) -> zio.aws.eks.model.primitives.RequiredClaimsValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfigRequest
  ): zio.aws.eks.model.OidcIdentityProviderConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
