package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.BoxedBoolean
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcConfigRequest(
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    endpointPublicAccess: Optional[BoxedBoolean] = Optional.Absent,
    endpointPrivateAccess: Optional[BoxedBoolean] = Optional.Absent,
    publicAccessCidrs: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.VpcConfigRequest = {
    import VpcConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.VpcConfigRequest
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        endpointPublicAccess.map(value => value: java.lang.Boolean)
      )(_.endpointPublicAccess)
      .optionallyWith(
        endpointPrivateAccess.map(value => value: java.lang.Boolean)
      )(_.endpointPrivateAccess)
      .optionallyWith(
        publicAccessCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicAccessCidrs)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.VpcConfigRequest.ReadOnly =
    zio.aws.eks.model.VpcConfigRequest.wrap(buildAwsValue())
}
object VpcConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.VpcConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.VpcConfigRequest =
      zio.aws.eks.model.VpcConfigRequest(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        endpointPublicAccess.map(value => value),
        endpointPrivateAccess.map(value => value),
        publicAccessCidrs.map(value => value)
      )
    def subnetIds: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def endpointPublicAccess: Optional[BoxedBoolean]
    def endpointPrivateAccess: Optional[BoxedBoolean]
    def publicAccessCidrs: Optional[List[String]]
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getEndpointPublicAccess: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("endpointPublicAccess", endpointPublicAccess)
    def getEndpointPrivateAccess: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("endpointPrivateAccess", endpointPrivateAccess)
    def getPublicAccessCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicAccessCidrs", publicAccessCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.VpcConfigRequest
  ) extends zio.aws.eks.model.VpcConfigRequest.ReadOnly {
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val endpointPublicAccess: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointPublicAccess())
        .map(value => value: BoxedBoolean)
    override val endpointPrivateAccess: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointPrivateAccess())
        .map(value => value: BoxedBoolean)
    override val publicAccessCidrs: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicAccessCidrs())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.VpcConfigRequest
  ): zio.aws.eks.model.VpcConfigRequest.ReadOnly = new Wrapper(impl)
}
