package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClustersResponse(
    clusters: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListClustersResponse.ReadOnly =
    zio.aws.eks.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListClustersResponse =
      zio.aws.eks.model.ListClustersResponse(
        clusters.map(value => value),
        nextToken.map(value => value)
      )
    def clusters: Optional[List[String]]
    def nextToken: Optional[String]
    def getClusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListClustersResponse
  ) extends zio.aws.eks.model.ListClustersResponse.ReadOnly {
    override val clusters: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListClustersResponse
  ): zio.aws.eks.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
