package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterHealth(
    issues: Optional[Iterable[zio.aws.eks.model.ClusterIssue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ClusterHealth = {
    import ClusterHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ClusterHealth
      .builder()
      .optionallyWith(
        issues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.issues)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ClusterHealth.ReadOnly =
    zio.aws.eks.model.ClusterHealth.wrap(buildAwsValue())
}
object ClusterHealth {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.ClusterHealth] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ClusterHealth =
      zio.aws.eks.model.ClusterHealth(
        issues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def issues: Optional[List[zio.aws.eks.model.ClusterIssue.ReadOnly]]
    def getIssues
        : ZIO[Any, AwsError, List[zio.aws.eks.model.ClusterIssue.ReadOnly]] =
      AwsError.unwrapOptionField("issues", issues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ClusterHealth
  ) extends zio.aws.eks.model.ClusterHealth.ReadOnly {
    override val issues
        : Optional[List[zio.aws.eks.model.ClusterIssue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.ClusterIssue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ClusterHealth
  ): zio.aws.eks.model.ClusterHealth.ReadOnly = new Wrapper(impl)
}
