package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.ListClustersRequestMaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListClustersRequest(
    maxResults: Optional[ListClustersRequestMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    include: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListClustersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListClustersRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.include)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListClustersRequest.ReadOnly =
    zio.aws.eks.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListClustersRequest =
      zio.aws.eks.model.ListClustersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        include.map(value => value)
      )
    def maxResults: Optional[ListClustersRequestMaxResults]
    def nextToken: Optional[String]
    def include: Optional[List[String]]
    def getMaxResults: ZIO[Any, AwsError, ListClustersRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInclude: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListClustersRequest
  ) extends zio.aws.eks.model.ListClustersRequest.ReadOnly {
    override val maxResults: Optional[ListClustersRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives.ListClustersRequestMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val include: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.include())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListClustersRequest
  ): zio.aws.eks.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
