package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ControlPlanePlacementRequest(
    groupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ControlPlanePlacementRequest = {
    import ControlPlanePlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ControlPlanePlacementRequest
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ControlPlanePlacementRequest.ReadOnly =
    zio.aws.eks.model.ControlPlanePlacementRequest.wrap(buildAwsValue())
}
object ControlPlanePlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ControlPlanePlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ControlPlanePlacementRequest =
      zio.aws.eks.model
        .ControlPlanePlacementRequest(groupName.map(value => value))
    def groupName: Optional[String]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ControlPlanePlacementRequest
  ) extends zio.aws.eks.model.ControlPlanePlacementRequest.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ControlPlanePlacementRequest
  ): zio.aws.eks.model.ControlPlanePlacementRequest.ReadOnly = new Wrapper(impl)
}
