package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFargateProfilesResponse(
    fargateProfileNames: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse = {
    import ListFargateProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse
      .builder()
      .optionallyWith(
        fargateProfileNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.fargateProfileNames)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly =
    zio.aws.eks.model.ListFargateProfilesResponse.wrap(buildAwsValue())
}
object ListFargateProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListFargateProfilesResponse =
      zio.aws.eks.model.ListFargateProfilesResponse(
        fargateProfileNames.map(value => value),
        nextToken.map(value => value)
      )
    def fargateProfileNames: Optional[List[String]]
    def nextToken: Optional[String]
    def getFargateProfileNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("fargateProfileNames", fargateProfileNames)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse
  ) extends zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly {
    override val fargateProfileNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fargateProfileNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse
  ): zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly = new Wrapper(impl)
}
