package zio.aws.eks
import zio.prelude.Subtype
import zio.aws.eks.model.primitives.{
  RequiredClaimsValue,
  LabelKey,
  TagValue,
  LabelValue,
  RequiredClaimsKey,
  TagKey
}
import java.time.Instant
import zio.aws.eks.model.primitives.LabelKey.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    type BoxedBoolean = Boolean
    type BoxedInteger = Int
    object Capacity extends Subtype[Int]
    type Capacity = zio.aws.eks.model.primitives.Capacity.Type
    object ClusterName extends Subtype[String]
    type ClusterName = zio.aws.eks.model.primitives.ClusterName.Type
    object DescribeAddonVersionsRequestMaxResults extends Subtype[Int]
    type DescribeAddonVersionsRequestMaxResults =
      zio.aws.eks.model.primitives.DescribeAddonVersionsRequestMaxResults.Type
    object FargateProfilesRequestMaxResults extends Subtype[Int]
    type FargateProfilesRequestMaxResults =
      zio.aws.eks.model.primitives.FargateProfilesRequestMaxResults.Type
    object LabelKey extends Subtype[String]
    type LabelKey = zio.aws.eks.model.primitives.LabelKey.Type
    object LabelValue extends Subtype[String]
    type LabelValue = zio.aws.eks.model.primitives.LabelValue.Type
    object ListAddonsRequestMaxResults extends Subtype[Int]
    type ListAddonsRequestMaxResults =
      zio.aws.eks.model.primitives.ListAddonsRequestMaxResults.Type
    object ListClustersRequestMaxResults extends Subtype[Int]
    type ListClustersRequestMaxResults =
      zio.aws.eks.model.primitives.ListClustersRequestMaxResults.Type
    object ListIdentityProviderConfigsRequestMaxResults extends Subtype[Int]
    type ListIdentityProviderConfigsRequestMaxResults =
      zio.aws.eks.model.primitives.ListIdentityProviderConfigsRequestMaxResults.Type
    object ListNodegroupsRequestMaxResults extends Subtype[Int]
    type ListNodegroupsRequestMaxResults =
      zio.aws.eks.model.primitives.ListNodegroupsRequestMaxResults.Type
    object ListUpdatesRequestMaxResults extends Subtype[Int]
    type ListUpdatesRequestMaxResults =
      zio.aws.eks.model.primitives.ListUpdatesRequestMaxResults.Type
    object NonZeroInteger extends Subtype[Int]
    type NonZeroInteger = zio.aws.eks.model.primitives.NonZeroInteger.Type
    object PercentCapacity extends Subtype[Int]
    type PercentCapacity = zio.aws.eks.model.primitives.PercentCapacity.Type
    object RequiredClaimsKey extends Subtype[String]
    type RequiredClaimsKey = zio.aws.eks.model.primitives.RequiredClaimsKey.Type
    object RequiredClaimsValue extends Subtype[String]
    type RequiredClaimsValue =
      zio.aws.eks.model.primitives.RequiredClaimsValue.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.eks.model.primitives.RoleArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.eks.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.eks.model.primitives.TagValue.Type
    object TaintKey extends Subtype[String]
    type TaintKey = zio.aws.eks.model.primitives.TaintKey.Type
    object TaintValue extends Subtype[String]
    type TaintValue = zio.aws.eks.model.primitives.TaintValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.eks.model.primitives.Timestamp.Type
    object ZeroCapacity extends Subtype[Int]
    type ZeroCapacity = zio.aws.eks.model.primitives.ZeroCapacity.Type
  }
  type AddonIssueList = List[zio.aws.eks.model.AddonIssue]
  type AddonVersionInfoList = List[zio.aws.eks.model.AddonVersionInfo]
  type Addons = List[zio.aws.eks.model.AddonInfo]
  type AutoScalingGroupList = List[zio.aws.eks.model.AutoScalingGroup]
  type ClusterIssueList = List[zio.aws.eks.model.ClusterIssue]
  type Compatibilities = List[zio.aws.eks.model.Compatibility]
  type EncryptionConfigList = List[zio.aws.eks.model.EncryptionConfig]
  type ErrorDetails = List[zio.aws.eks.model.ErrorDetail]
  type FargateProfileLabel = Map[String, String]
  type FargateProfileSelectors = List[zio.aws.eks.model.FargateProfileSelector]
  type IdentityProviderConfigs = List[zio.aws.eks.model.IdentityProviderConfig]
  type IncludeClustersList = List[String]
  type IssueList = List[zio.aws.eks.model.Issue]
  type LabelsKeyList = List[String]
  type LabelsMap = Map[LabelKey, LabelValue]
  type LogSetups = List[zio.aws.eks.model.LogSetup]
  type LogTypes = List[zio.aws.eks.model.LogType]
  type RequiredClaimsMap = Map[RequiredClaimsKey, RequiredClaimsValue]
  type StringList = List[String]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TaintsList = List[zio.aws.eks.model.Taint]
  type UpdateParams = List[zio.aws.eks.model.UpdateParam]
}
