package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MarketplaceInformation(
    productId: Optional[String] = Optional.Absent,
    productUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.MarketplaceInformation = {
    import MarketplaceInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.MarketplaceInformation
      .builder()
      .optionallyWith(productId.map(value => value: java.lang.String))(
        _.productId
      )
      .optionallyWith(productUrl.map(value => value: java.lang.String))(
        _.productUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.MarketplaceInformation.ReadOnly =
    zio.aws.eks.model.MarketplaceInformation.wrap(buildAwsValue())
}
object MarketplaceInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.MarketplaceInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.MarketplaceInformation =
      zio.aws.eks.model.MarketplaceInformation(
        productId.map(value => value),
        productUrl.map(value => value)
      )
    def productId: Optional[String]
    def productUrl: Optional[String]
    def getProductId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productUrl", productUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.MarketplaceInformation
  ) extends zio.aws.eks.model.MarketplaceInformation.ReadOnly {
    override val productId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => value: String)
    override val productUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.MarketplaceInformation
  ): zio.aws.eks.model.MarketplaceInformation.ReadOnly = new Wrapper(impl)
}
