package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eks.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: String,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.TagResourceRequest.ReadOnly =
    zio.aws.eks.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.TagResourceRequest =
      zio.aws.eks.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: String
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.TagResourceRequest
  ) extends zio.aws.eks.model.TagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.eks.model.primitives.TagKey(key) -> zio.aws.eks.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.TagResourceRequest
  ): zio.aws.eks.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
