package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.DescribeAddonVersionsRequestMaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAddonVersionsRequest(
    kubernetesVersion: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeAddonVersionsRequestMaxResults] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    addonName: Optional[String] = Optional.Absent,
    types: Optional[Iterable[String]] = Optional.Absent,
    publishers: Optional[Iterable[String]] = Optional.Absent,
    owners: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest = {
    import DescribeAddonVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
      .builder()
      .optionallyWith(kubernetesVersion.map(value => value: java.lang.String))(
        _.kubernetesVersion
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeAddonVersionsRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        publishers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publishers)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonVersionsRequest.ReadOnly =
    zio.aws.eks.model.DescribeAddonVersionsRequest.wrap(buildAwsValue())
}
object DescribeAddonVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonVersionsRequest =
      zio.aws.eks.model.DescribeAddonVersionsRequest(
        kubernetesVersion.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        addonName.map(value => value),
        types.map(value => value),
        publishers.map(value => value),
        owners.map(value => value)
      )
    def kubernetesVersion: Optional[String]
    def maxResults: Optional[DescribeAddonVersionsRequestMaxResults]
    def nextToken: Optional[String]
    def addonName: Optional[String]
    def types: Optional[List[String]]
    def publishers: Optional[List[String]]
    def owners: Optional[List[String]]
    def getKubernetesVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kubernetesVersion", kubernetesVersion)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeAddonVersionsRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("types", types)
    def getPublishers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publishers", publishers)
    def getOwners: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("owners", owners)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
  ) extends zio.aws.eks.model.DescribeAddonVersionsRequest.ReadOnly {
    override val kubernetesVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kubernetesVersion())
      .map(value => value: String)
    override val maxResults: Optional[DescribeAddonVersionsRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives
            .DescribeAddonVersionsRequestMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val addonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonName())
      .map(value => value: String)
    override val types: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val publishers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.publishers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val owners: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
  ): zio.aws.eks.model.DescribeAddonVersionsRequest.ReadOnly = new Wrapper(impl)
}
