package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey, RoleArn, ClusterName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAddonRequest(
    clusterName: ClusterName,
    addonName: String,
    addonVersion: Optional[String] = Optional.Absent,
    serviceAccountRoleArn: Optional[RoleArn] = Optional.Absent,
    resolveConflicts: Optional[zio.aws.eks.model.ResolveConflicts] =
      Optional.Absent,
    clientRequestToken: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    configurationValues: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateAddonRequest = {
    import CreateAddonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateAddonRequest
      .builder()
      .clusterName(ClusterName.unwrap(clusterName): java.lang.String)
      .addonName(addonName: java.lang.String)
      .optionallyWith(addonVersion.map(value => value: java.lang.String))(
        _.addonVersion
      )
      .optionallyWith(
        serviceAccountRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.serviceAccountRoleArn)
      .optionallyWith(resolveConflicts.map(value => value.unwrap))(
        _.resolveConflicts
      )
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        configurationValues.map(value => value: java.lang.String)
      )(_.configurationValues)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateAddonRequest.ReadOnly =
    zio.aws.eks.model.CreateAddonRequest.wrap(buildAwsValue())
}
object CreateAddonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateAddonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateAddonRequest =
      zio.aws.eks.model.CreateAddonRequest(
        clusterName,
        addonName,
        addonVersion.map(value => value),
        serviceAccountRoleArn.map(value => value),
        resolveConflicts.map(value => value),
        clientRequestToken.map(value => value),
        tags.map(value => value),
        configurationValues.map(value => value)
      )
    def clusterName: ClusterName
    def addonName: String
    def addonVersion: Optional[String]
    def serviceAccountRoleArn: Optional[RoleArn]
    def resolveConflicts: Optional[zio.aws.eks.model.ResolveConflicts]
    def clientRequestToken: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def configurationValues: Optional[String]
    def getClusterName: ZIO[Any, Nothing, ClusterName] =
      ZIO.succeed(clusterName)
    def getAddonName: ZIO[Any, Nothing, String] = ZIO.succeed(addonName)
    def getAddonVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonVersion", addonVersion)
    def getServiceAccountRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("serviceAccountRoleArn", serviceAccountRoleArn)
    def getResolveConflicts
        : ZIO[Any, AwsError, zio.aws.eks.model.ResolveConflicts] =
      AwsError.unwrapOptionField("resolveConflicts", resolveConflicts)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationValues", configurationValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateAddonRequest
  ) extends zio.aws.eks.model.CreateAddonRequest.ReadOnly {
    override val clusterName: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.clusterName())
    override val addonName: String = impl.addonName(): String
    override val addonVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonVersion())
      .map(value => value: String)
    override val serviceAccountRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceAccountRoleArn())
        .map(value => zio.aws.eks.model.primitives.RoleArn(value))
    override val resolveConflicts
        : Optional[zio.aws.eks.model.ResolveConflicts] = zio.aws.core.internal
      .optionalFromNullable(impl.resolveConflicts())
      .map(value => zio.aws.eks.model.ResolveConflicts.wrap(value))
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val configurationValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationValues())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateAddonRequest
  ): zio.aws.eks.model.CreateAddonRequest.ReadOnly = new Wrapper(impl)
}
