package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TaintValue, TaintKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Taint(
    key: Optional[TaintKey] = Optional.Absent,
    value: Optional[TaintValue] = Optional.Absent,
    effect: Optional[zio.aws.eks.model.TaintEffect] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Taint = {
    import Taint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Taint
      .builder()
      .optionallyWith(
        key.map(value => TaintKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => TaintValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(effect.map(value => value.unwrap))(_.effect)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Taint.ReadOnly =
    zio.aws.eks.model.Taint.wrap(buildAwsValue())
}
object Taint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Taint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Taint = zio.aws.eks.model.Taint(
      key.map(value => value),
      value.map(value => value),
      effect.map(value => value)
    )
    def key: Optional[TaintKey]
    def value: Optional[TaintValue]
    def effect: Optional[zio.aws.eks.model.TaintEffect]
    def getKey: ZIO[Any, AwsError, TaintKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TaintValue] =
      AwsError.unwrapOptionField("value", value)
    def getEffect: ZIO[Any, AwsError, zio.aws.eks.model.TaintEffect] =
      AwsError.unwrapOptionField("effect", effect)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Taint
  ) extends zio.aws.eks.model.Taint.ReadOnly {
    override val key: Optional[TaintKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.eks.model.primitives.TaintKey(value))
    override val value: Optional[TaintValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.eks.model.primitives.TaintValue(value))
    override val effect: Optional[zio.aws.eks.model.TaintEffect] =
      zio.aws.core.internal
        .optionalFromNullable(impl.effect())
        .map(value => zio.aws.eks.model.TaintEffect.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Taint
  ): zio.aws.eks.model.Taint.ReadOnly = new Wrapper(impl)
}
