package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAddonConfigurationRequest(
    addonName: String,
    addonVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationRequest = {
    import DescribeAddonConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationRequest
      .builder()
      .addonName(addonName: java.lang.String)
      .addonVersion(addonVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonConfigurationRequest.ReadOnly =
    zio.aws.eks.model.DescribeAddonConfigurationRequest.wrap(buildAwsValue())
}
object DescribeAddonConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonConfigurationRequest =
      zio.aws.eks.model
        .DescribeAddonConfigurationRequest(addonName, addonVersion)
    def addonName: String
    def addonVersion: String
    def getAddonName: ZIO[Any, Nothing, String] = ZIO.succeed(addonName)
    def getAddonVersion: ZIO[Any, Nothing, String] = ZIO.succeed(addonVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationRequest
  ) extends zio.aws.eks.model.DescribeAddonConfigurationRequest.ReadOnly {
    override val addonName: String = impl.addonName(): String
    override val addonVersion: String = impl.addonVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationRequest
  ): zio.aws.eks.model.DescribeAddonConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
