package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.eks.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.LogType
  ): zio.aws.eks.model.LogType = value match {
    case software.amazon.awssdk.services.eks.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.LogType.API =>
      val r = api
      r
    case software.amazon.awssdk.services.eks.model.LogType.AUDIT =>
      val r = audit
      r
    case software.amazon.awssdk.services.eks.model.LogType.AUTHENTICATOR =>
      val r = authenticator
      r
    case software.amazon.awssdk.services.eks.model.LogType.CONTROLLER_MANAGER =>
      val r = controllerManager
      r
    case software.amazon.awssdk.services.eks.model.LogType.SCHEDULER =>
      val r = scheduler
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.LogType {
    override def unwrap: software.amazon.awssdk.services.eks.model.LogType =
      software.amazon.awssdk.services.eks.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object api extends zio.aws.eks.model.LogType {
    override def unwrap: software.amazon.awssdk.services.eks.model.LogType =
      software.amazon.awssdk.services.eks.model.LogType.API
  }
  case object audit extends zio.aws.eks.model.LogType {
    override def unwrap: software.amazon.awssdk.services.eks.model.LogType =
      software.amazon.awssdk.services.eks.model.LogType.AUDIT
  }
  case object authenticator extends zio.aws.eks.model.LogType {
    override def unwrap: software.amazon.awssdk.services.eks.model.LogType =
      software.amazon.awssdk.services.eks.model.LogType.AUTHENTICATOR
  }
  case object controllerManager extends zio.aws.eks.model.LogType {
    override def unwrap: software.amazon.awssdk.services.eks.model.LogType =
      software.amazon.awssdk.services.eks.model.LogType.CONTROLLER_MANAGER
  }
  case object scheduler extends zio.aws.eks.model.LogType {
    override def unwrap: software.amazon.awssdk.services.eks.model.LogType =
      software.amazon.awssdk.services.eks.model.LogType.SCHEDULER
  }
}
