package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{PercentCapacity, NonZeroInteger}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NodegroupUpdateConfig(
    maxUnavailable: Optional[NonZeroInteger] = Optional.Absent,
    maxUnavailablePercentage: Optional[PercentCapacity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.NodegroupUpdateConfig = {
    import NodegroupUpdateConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.NodegroupUpdateConfig
      .builder()
      .optionallyWith(
        maxUnavailable.map(value => NonZeroInteger.unwrap(value): Integer)
      )(_.maxUnavailable)
      .optionallyWith(
        maxUnavailablePercentage.map(value =>
          PercentCapacity.unwrap(value): Integer
        )
      )(_.maxUnavailablePercentage)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly =
    zio.aws.eks.model.NodegroupUpdateConfig.wrap(buildAwsValue())
}
object NodegroupUpdateConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.NodegroupUpdateConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.NodegroupUpdateConfig =
      zio.aws.eks.model.NodegroupUpdateConfig(
        maxUnavailable.map(value => value),
        maxUnavailablePercentage.map(value => value)
      )
    def maxUnavailable: Optional[NonZeroInteger]
    def maxUnavailablePercentage: Optional[PercentCapacity]
    def getMaxUnavailable: ZIO[Any, AwsError, NonZeroInteger] =
      AwsError.unwrapOptionField("maxUnavailable", maxUnavailable)
    def getMaxUnavailablePercentage: ZIO[Any, AwsError, PercentCapacity] =
      AwsError.unwrapOptionField(
        "maxUnavailablePercentage",
        maxUnavailablePercentage
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.NodegroupUpdateConfig
  ) extends zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly {
    override val maxUnavailable: Optional[NonZeroInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxUnavailable())
        .map(value => zio.aws.eks.model.primitives.NonZeroInteger(value))
    override val maxUnavailablePercentage: Optional[PercentCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxUnavailablePercentage())
        .map(value => zio.aws.eks.model.primitives.PercentCapacity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.NodegroupUpdateConfig
  ): zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly = new Wrapper(impl)
}
