package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIdentityProviderConfigsResponse(
    identityProviderConfigs: Optional[
      Iterable[zio.aws.eks.model.IdentityProviderConfig]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse = {
    import ListIdentityProviderConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse
      .builder()
      .optionallyWith(
        identityProviderConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityProviderConfigs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly =
    zio.aws.eks.model.ListIdentityProviderConfigsResponse.wrap(buildAwsValue())
}
object ListIdentityProviderConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListIdentityProviderConfigsResponse =
      zio.aws.eks.model.ListIdentityProviderConfigsResponse(
        identityProviderConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def identityProviderConfigs
        : Optional[List[zio.aws.eks.model.IdentityProviderConfig.ReadOnly]]
    def nextToken: Optional[String]
    def getIdentityProviderConfigs: ZIO[Any, AwsError, List[
      zio.aws.eks.model.IdentityProviderConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "identityProviderConfigs",
      identityProviderConfigs
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse
  ) extends zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly {
    override val identityProviderConfigs
        : Optional[List[zio.aws.eks.model.IdentityProviderConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.IdentityProviderConfig.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse
  ): zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
