package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAddonsResponse(
    addons: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListAddonsResponse = {
    import ListAddonsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListAddonsResponse
      .builder()
      .optionallyWith(
        addons.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addons)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListAddonsResponse.ReadOnly =
    zio.aws.eks.model.ListAddonsResponse.wrap(buildAwsValue())
}
object ListAddonsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListAddonsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListAddonsResponse =
      zio.aws.eks.model.ListAddonsResponse(
        addons.map(value => value),
        nextToken.map(value => value)
      )
    def addons: Optional[List[String]]
    def nextToken: Optional[String]
    def getAddons: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("addons", addons)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListAddonsResponse
  ) extends zio.aws.eks.model.ListAddonsResponse.ReadOnly {
    override val addons: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.addons())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListAddonsResponse
  ): zio.aws.eks.model.ListAddonsResponse.ReadOnly = new Wrapper(impl)
}
