package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUpdateRequest(
    name: String,
    updateId: String,
    nodegroupName: Optional[String] = Optional.Absent,
    addonName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeUpdateRequest = {
    import DescribeUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeUpdateRequest
      .builder()
      .name(name: java.lang.String)
      .updateId(updateId: java.lang.String)
      .optionallyWith(nodegroupName.map(value => value: java.lang.String))(
        _.nodegroupName
      )
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeUpdateRequest.ReadOnly =
    zio.aws.eks.model.DescribeUpdateRequest.wrap(buildAwsValue())
}
object DescribeUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeUpdateRequest =
      zio.aws.eks.model.DescribeUpdateRequest(
        name,
        updateId,
        nodegroupName.map(value => value),
        addonName.map(value => value)
      )
    def name: String
    def updateId: String
    def nodegroupName: Optional[String]
    def addonName: Optional[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getUpdateId: ZIO[Any, Nothing, String] = ZIO.succeed(updateId)
    def getNodegroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupName", nodegroupName)
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeUpdateRequest
  ) extends zio.aws.eks.model.DescribeUpdateRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val updateId: String = impl.updateId(): String
    override val nodegroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodegroupName())
      .map(value => value: String)
    override val addonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeUpdateRequest
  ): zio.aws.eks.model.DescribeUpdateRequest.ReadOnly = new Wrapper(impl)
}
