package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateEncryptionConfigRequest(
    clusterName: String,
    encryptionConfig: Iterable[zio.aws.eks.model.EncryptionConfig],
    clientRequestToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest = {
    import AssociateEncryptionConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .encryptionConfig(encryptionConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AssociateEncryptionConfigRequest.ReadOnly =
    zio.aws.eks.model.AssociateEncryptionConfigRequest.wrap(buildAwsValue())
}
object AssociateEncryptionConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AssociateEncryptionConfigRequest =
      zio.aws.eks.model.AssociateEncryptionConfigRequest(
        clusterName,
        encryptionConfig.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value)
      )
    def clusterName: String
    def encryptionConfig: List[zio.aws.eks.model.EncryptionConfig.ReadOnly]
    def clientRequestToken: Optional[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getEncryptionConfig
        : ZIO[Any, Nothing, List[zio.aws.eks.model.EncryptionConfig.ReadOnly]] =
      ZIO.succeed(encryptionConfig)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest
  ) extends zio.aws.eks.model.AssociateEncryptionConfigRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val encryptionConfig
        : List[zio.aws.eks.model.EncryptionConfig.ReadOnly] = impl
      .encryptionConfig()
      .asScala
      .map { item =>
        zio.aws.eks.model.EncryptionConfig.wrap(item)
      }
      .toList
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest
  ): zio.aws.eks.model.AssociateEncryptionConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
