package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.ListUpdatesRequestMaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUpdatesRequest(
    name: String,
    nodegroupName: Optional[String] = Optional.Absent,
    addonName: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListUpdatesRequestMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListUpdatesRequest = {
    import ListUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListUpdatesRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(nodegroupName.map(value => value: java.lang.String))(
        _.nodegroupName
      )
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          ListUpdatesRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListUpdatesRequest.ReadOnly =
    zio.aws.eks.model.ListUpdatesRequest.wrap(buildAwsValue())
}
object ListUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListUpdatesRequest =
      zio.aws.eks.model.ListUpdatesRequest(
        name,
        nodegroupName.map(value => value),
        addonName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: String
    def nodegroupName: Optional[String]
    def addonName: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[ListUpdatesRequestMaxResults]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getNodegroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupName", nodegroupName)
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListUpdatesRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListUpdatesRequest
  ) extends zio.aws.eks.model.ListUpdatesRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val nodegroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodegroupName())
      .map(value => value: String)
    override val addonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonName())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ListUpdatesRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives.ListUpdatesRequestMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListUpdatesRequest
  ): zio.aws.eks.model.ListUpdatesRequest.ReadOnly = new Wrapper(impl)
}
