package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterClusterRequest(name: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeregisterClusterRequest = {
    import DeregisterClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeregisterClusterRequest
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeregisterClusterRequest.ReadOnly =
    zio.aws.eks.model.DeregisterClusterRequest.wrap(buildAwsValue())
}
object DeregisterClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeregisterClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeregisterClusterRequest =
      zio.aws.eks.model.DeregisterClusterRequest(name)
    def name: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeregisterClusterRequest
  ) extends zio.aws.eks.model.DeregisterClusterRequest.ReadOnly {
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeregisterClusterRequest
  ): zio.aws.eks.model.DeregisterClusterRequest.ReadOnly = new Wrapper(impl)
}
