package zio.aws.eks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{TagValue, TagKey, Timestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Cluster(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    roleArn: Optional[String] = Optional.Absent,
    resourcesVpcConfig: Optional[zio.aws.eks.model.VpcConfigResponse] =
      Optional.Absent,
    kubernetesNetworkConfig: Optional[
      zio.aws.eks.model.KubernetesNetworkConfigResponse
    ] = Optional.Absent,
    logging: Optional[zio.aws.eks.model.Logging] = Optional.Absent,
    identity: Optional[zio.aws.eks.model.Identity] = Optional.Absent,
    status: Optional[zio.aws.eks.model.ClusterStatus] = Optional.Absent,
    certificateAuthority: Optional[zio.aws.eks.model.Certificate] =
      Optional.Absent,
    clientRequestToken: Optional[String] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    encryptionConfig: Optional[Iterable[zio.aws.eks.model.EncryptionConfig]] =
      Optional.Absent,
    connectorConfig: Optional[zio.aws.eks.model.ConnectorConfigResponse] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Cluster
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(resourcesVpcConfig.map(value => value.buildAwsValue()))(
        _.resourcesVpcConfig
      )
      .optionallyWith(
        kubernetesNetworkConfig.map(value => value.buildAwsValue())
      )(_.kubernetesNetworkConfig)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(identity.map(value => value.buildAwsValue()))(_.identity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(certificateAuthority.map(value => value.buildAwsValue()))(
        _.certificateAuthority
      )
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.encryptionConfig)
      .optionallyWith(connectorConfig.map(value => value.buildAwsValue()))(
        _.connectorConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Cluster.ReadOnly =
    zio.aws.eks.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Cluster = zio.aws.eks.model.Cluster(
      name.map(value => value),
      arn.map(value => value),
      createdAt.map(value => value),
      version.map(value => value),
      endpoint.map(value => value),
      roleArn.map(value => value),
      resourcesVpcConfig.map(value => value.asEditable),
      kubernetesNetworkConfig.map(value => value.asEditable),
      logging.map(value => value.asEditable),
      identity.map(value => value.asEditable),
      status.map(value => value),
      certificateAuthority.map(value => value.asEditable),
      clientRequestToken.map(value => value),
      platformVersion.map(value => value),
      tags.map(value => value),
      encryptionConfig.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      connectorConfig.map(value => value.asEditable)
    )
    def name: Optional[String]
    def arn: Optional[String]
    def createdAt: Optional[Timestamp]
    def version: Optional[String]
    def endpoint: Optional[String]
    def roleArn: Optional[String]
    def resourcesVpcConfig
        : Optional[zio.aws.eks.model.VpcConfigResponse.ReadOnly]
    def kubernetesNetworkConfig
        : Optional[zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly]
    def logging: Optional[zio.aws.eks.model.Logging.ReadOnly]
    def identity: Optional[zio.aws.eks.model.Identity.ReadOnly]
    def status: Optional[zio.aws.eks.model.ClusterStatus]
    def certificateAuthority: Optional[zio.aws.eks.model.Certificate.ReadOnly]
    def clientRequestToken: Optional[String]
    def platformVersion: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def encryptionConfig
        : Optional[List[zio.aws.eks.model.EncryptionConfig.ReadOnly]]
    def connectorConfig
        : Optional[zio.aws.eks.model.ConnectorConfigResponse.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getResourcesVpcConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.VpcConfigResponse.ReadOnly] =
      AwsError.unwrapOptionField("resourcesVpcConfig", resourcesVpcConfig)
    def getKubernetesNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kubernetesNetworkConfig",
      kubernetesNetworkConfig
    )
    def getLogging: ZIO[Any, AwsError, zio.aws.eks.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getIdentity: ZIO[Any, AwsError, zio.aws.eks.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("identity", identity)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.ClusterStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificateAuthority
        : ZIO[Any, AwsError, zio.aws.eks.model.Certificate.ReadOnly] =
      AwsError.unwrapOptionField("certificateAuthority", certificateAuthority)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfig: ZIO[Any, AwsError, List[
      zio.aws.eks.model.EncryptionConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getConnectorConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.ConnectorConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("connectorConfig", connectorConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Cluster
  ) extends zio.aws.eks.model.Cluster.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
    override val resourcesVpcConfig
        : Optional[zio.aws.eks.model.VpcConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcesVpcConfig())
        .map(value => zio.aws.eks.model.VpcConfigResponse.wrap(value))
    override val kubernetesNetworkConfig
        : Optional[zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetesNetworkConfig())
        .map(value =>
          zio.aws.eks.model.KubernetesNetworkConfigResponse.wrap(value)
        )
    override val logging: Optional[zio.aws.eks.model.Logging.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logging())
        .map(value => zio.aws.eks.model.Logging.wrap(value))
    override val identity: Optional[zio.aws.eks.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identity())
        .map(value => zio.aws.eks.model.Identity.wrap(value))
    override val status: Optional[zio.aws.eks.model.ClusterStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.eks.model.ClusterStatus.wrap(value))
    override val certificateAuthority
        : Optional[zio.aws.eks.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthority())
        .map(value => zio.aws.eks.model.Certificate.wrap(value))
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val encryptionConfig
        : Optional[List[zio.aws.eks.model.EncryptionConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.EncryptionConfig.wrap(item)
          }.toList
        )
    override val connectorConfig
        : Optional[zio.aws.eks.model.ConnectorConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorConfig())
        .map(value => zio.aws.eks.model.ConnectorConfigResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Cluster
  ): zio.aws.eks.model.Cluster.ReadOnly = new Wrapper(impl)
}
