package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAddonVersionsResponse(
    addons: Optional[Iterable[zio.aws.eks.model.AddonInfo]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse = {
    import DescribeAddonVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
      .builder()
      .optionallyWith(
        addons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addons)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly =
    zio.aws.eks.model.DescribeAddonVersionsResponse.wrap(buildAwsValue())
}
object DescribeAddonVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonVersionsResponse =
      zio.aws.eks.model.DescribeAddonVersionsResponse(
        addons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addons: Optional[List[zio.aws.eks.model.AddonInfo.ReadOnly]]
    def nextToken: Optional[String]
    def getAddons
        : ZIO[Any, AwsError, List[zio.aws.eks.model.AddonInfo.ReadOnly]] =
      AwsError.unwrapOptionField("addons", addons)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
  ) extends zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly {
    override val addons: Optional[List[zio.aws.eks.model.AddonInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.AddonInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse
  ): zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
