package zio.aws.eks
import zio.aws.eks.model.UpdateNodegroupVersionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.eks.model.{
  ListFargateProfilesRequest,
  UpdateClusterVersionRequest,
  UpdateNodegroupVersionRequest,
  DeleteFargateProfileRequest,
  DisassociateIdentityProviderConfigRequest,
  CreateNodegroupRequest,
  DeleteAddonRequest,
  ListIdentityProviderConfigsRequest,
  DescribeAddonRequest,
  ListTagsForResourceRequest,
  DeregisterClusterRequest,
  AssociateIdentityProviderConfigRequest,
  ListUpdatesRequest,
  CreateClusterRequest,
  DescribeUpdateRequest,
  AssociateEncryptionConfigRequest,
  DeleteClusterRequest,
  ListAddonsRequest,
  DescribeIdentityProviderConfigRequest,
  RegisterClusterRequest,
  CreateAddonRequest,
  DeleteNodegroupRequest,
  UntagResourceRequest,
  CreateFargateProfileRequest,
  DescribeClusterRequest,
  UpdateNodegroupConfigRequest,
  DescribeAddonVersionsRequest,
  ListNodegroupsRequest,
  DescribeNodegroupRequest,
  ListClustersRequest,
  UpdateClusterConfigRequest,
  TagResourceRequest,
  DescribeFargateProfileRequest,
  UpdateAddonRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.eks.EksAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object EksMock extends Mock[Eks] {
  object UpdateClusterVersion
      extends Effect[
        UpdateClusterVersionRequest,
        AwsError,
        zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly
      ]
  object CreateNodegroup
      extends Effect[
        CreateNodegroupRequest,
        AwsError,
        zio.aws.eks.model.CreateNodegroupResponse.ReadOnly
      ]
  object DescribeUpdate
      extends Effect[
        DescribeUpdateRequest,
        AwsError,
        zio.aws.eks.model.DescribeUpdateResponse.ReadOnly
      ]
  object DescribeAddon
      extends Effect[
        DescribeAddonRequest,
        AwsError,
        zio.aws.eks.model.DescribeAddonResponse.ReadOnly
      ]
  object DeleteNodegroup
      extends Effect[
        DeleteNodegroupRequest,
        AwsError,
        zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly
      ]
  object ListIdentityProviderConfigs
      extends Stream[
        ListIdentityProviderConfigsRequest,
        AwsError,
        zio.aws.eks.model.IdentityProviderConfig.ReadOnly
      ]
  object ListIdentityProviderConfigsPaginated
      extends Effect[
        ListIdentityProviderConfigsRequest,
        AwsError,
        zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly
      ]
  object DeregisterCluster
      extends Effect[
        DeregisterClusterRequest,
        AwsError,
        zio.aws.eks.model.DeregisterClusterResponse.ReadOnly
      ]
  object DescribeIdentityProviderConfig
      extends Effect[
        DescribeIdentityProviderConfigRequest,
        AwsError,
        zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly
      ]
  object DescribeFargateProfile
      extends Effect[
        DescribeFargateProfileRequest,
        AwsError,
        zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.eks.model.CreateClusterResponse.ReadOnly
      ]
  object ListUpdates extends Stream[ListUpdatesRequest, AwsError, String]
  object ListUpdatesPaginated
      extends Effect[
        ListUpdatesRequest,
        AwsError,
        zio.aws.eks.model.ListUpdatesResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.eks.model.DeleteClusterResponse.ReadOnly
      ]
  object DescribeAddonVersions
      extends Stream[
        DescribeAddonVersionsRequest,
        AwsError,
        zio.aws.eks.model.AddonInfo.ReadOnly
      ]
  object DescribeAddonVersionsPaginated
      extends Effect[
        DescribeAddonVersionsRequest,
        AwsError,
        zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly
      ]
  object RegisterCluster
      extends Effect[
        RegisterClusterRequest,
        AwsError,
        zio.aws.eks.model.RegisterClusterResponse.ReadOnly
      ]
  object DisassociateIdentityProviderConfig
      extends Effect[
        DisassociateIdentityProviderConfigRequest,
        AwsError,
        zio.aws.eks.model.DisassociateIdentityProviderConfigResponse.ReadOnly
      ]
  object DeleteFargateProfile
      extends Effect[
        DeleteFargateProfileRequest,
        AwsError,
        zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.eks.model.UntagResourceResponse.ReadOnly
      ]
  object ListNodegroups extends Stream[ListNodegroupsRequest, AwsError, String]
  object ListNodegroupsPaginated
      extends Effect[
        ListNodegroupsRequest,
        AwsError,
        zio.aws.eks.model.ListNodegroupsResponse.ReadOnly
      ]
  object CreateAddon
      extends Effect[
        CreateAddonRequest,
        AwsError,
        zio.aws.eks.model.CreateAddonResponse.ReadOnly
      ]
  object UpdateNodegroupVersion
      extends Effect[UpdateNodegroupVersionRequest, AwsError, ReadOnly]
  object AssociateEncryptionConfig
      extends Effect[
        AssociateEncryptionConfigRequest,
        AwsError,
        zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly
      ]
  object DescribeCluster
      extends Effect[
        DescribeClusterRequest,
        AwsError,
        zio.aws.eks.model.DescribeClusterResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.eks.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListClusters extends Stream[ListClustersRequest, AwsError, String]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.eks.model.ListClustersResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.eks.model.TagResourceResponse.ReadOnly
      ]
  object UpdateAddon
      extends Effect[
        UpdateAddonRequest,
        AwsError,
        zio.aws.eks.model.UpdateAddonResponse.ReadOnly
      ]
  object AssociateIdentityProviderConfig
      extends Effect[
        AssociateIdentityProviderConfigRequest,
        AwsError,
        zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly
      ]
  object DeleteAddon
      extends Effect[
        DeleteAddonRequest,
        AwsError,
        zio.aws.eks.model.DeleteAddonResponse.ReadOnly
      ]
  object DescribeNodegroup
      extends Effect[
        DescribeNodegroupRequest,
        AwsError,
        zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly
      ]
  object CreateFargateProfile
      extends Effect[
        CreateFargateProfileRequest,
        AwsError,
        zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly
      ]
  object UpdateClusterConfig
      extends Effect[
        UpdateClusterConfigRequest,
        AwsError,
        zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly
      ]
  object UpdateNodegroupConfig
      extends Effect[
        UpdateNodegroupConfigRequest,
        AwsError,
        zio.aws.eks.model.UpdateNodegroupConfigResponse.ReadOnly
      ]
  object ListFargateProfiles
      extends Stream[ListFargateProfilesRequest, AwsError, String]
  object ListFargateProfilesPaginated
      extends Effect[
        ListFargateProfilesRequest,
        AwsError,
        zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly
      ]
  object ListAddons extends Stream[ListAddonsRequest, AwsError, String]
  object ListAddonsPaginated
      extends Effect[
        ListAddonsRequest,
        AwsError,
        zio.aws.eks.model.ListAddonsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Eks] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Eks] { rts =>
        zio.ZIO.succeed {
          new Eks {
            val api: EksAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Eks = this
            def updateClusterVersion(request: UpdateClusterVersionRequest): IO[
              AwsError,
              zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly
            ] = proxy(UpdateClusterVersion, request)
            def createNodegroup(request: CreateNodegroupRequest): IO[
              AwsError,
              zio.aws.eks.model.CreateNodegroupResponse.ReadOnly
            ] = proxy(CreateNodegroup, request)
            def describeUpdate(
                request: DescribeUpdateRequest
            ): IO[AwsError, zio.aws.eks.model.DescribeUpdateResponse.ReadOnly] =
              proxy(DescribeUpdate, request)
            def describeAddon(
                request: DescribeAddonRequest
            ): IO[AwsError, zio.aws.eks.model.DescribeAddonResponse.ReadOnly] =
              proxy(DescribeAddon, request)
            def deleteNodegroup(request: DeleteNodegroupRequest): IO[
              AwsError,
              zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly
            ] = proxy(DeleteNodegroup, request)
            def listIdentityProviderConfigs(
                request: ListIdentityProviderConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.eks.model.IdentityProviderConfig.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIdentityProviderConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIdentityProviderConfigsPaginated(
                request: ListIdentityProviderConfigsRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly
            ] = proxy(ListIdentityProviderConfigsPaginated, request)
            def deregisterCluster(request: DeregisterClusterRequest): IO[
              AwsError,
              zio.aws.eks.model.DeregisterClusterResponse.ReadOnly
            ] = proxy(DeregisterCluster, request)
            def describeIdentityProviderConfig(
                request: DescribeIdentityProviderConfigRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly
            ] = proxy(DescribeIdentityProviderConfig, request)
            def describeFargateProfile(
                request: DescribeFargateProfileRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly
            ] = proxy(DescribeFargateProfile, request)
            def createCluster(
                request: CreateClusterRequest
            ): IO[AwsError, zio.aws.eks.model.CreateClusterResponse.ReadOnly] =
              proxy(CreateCluster, request)
            def listUpdates(
                request: ListUpdatesRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListUpdates, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listUpdatesPaginated(
                request: ListUpdatesRequest
            ): IO[AwsError, zio.aws.eks.model.ListUpdatesResponse.ReadOnly] =
              proxy(ListUpdatesPaginated, request)
            def deleteCluster(
                request: DeleteClusterRequest
            ): IO[AwsError, zio.aws.eks.model.DeleteClusterResponse.ReadOnly] =
              proxy(DeleteCluster, request)
            def describeAddonVersions(
                request: DescribeAddonVersionsRequest
            ): ZStream[Any, AwsError, zio.aws.eks.model.AddonInfo.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeAddonVersions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeAddonVersionsPaginated(
                request: DescribeAddonVersionsRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly
            ] = proxy(DescribeAddonVersionsPaginated, request)
            def registerCluster(request: RegisterClusterRequest): IO[
              AwsError,
              zio.aws.eks.model.RegisterClusterResponse.ReadOnly
            ] = proxy(RegisterCluster, request)
            def disassociateIdentityProviderConfig(
                request: DisassociateIdentityProviderConfigRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.DisassociateIdentityProviderConfigResponse.ReadOnly
            ] = proxy(DisassociateIdentityProviderConfig, request)
            def deleteFargateProfile(request: DeleteFargateProfileRequest): IO[
              AwsError,
              zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly
            ] = proxy(DeleteFargateProfile, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.eks.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def listNodegroups(
                request: ListNodegroupsRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListNodegroups, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listNodegroupsPaginated(
                request: ListNodegroupsRequest
            ): IO[AwsError, zio.aws.eks.model.ListNodegroupsResponse.ReadOnly] =
              proxy(ListNodegroupsPaginated, request)
            def createAddon(
                request: CreateAddonRequest
            ): IO[AwsError, zio.aws.eks.model.CreateAddonResponse.ReadOnly] =
              proxy(CreateAddon, request)
            def updateNodegroupVersion(
                request: UpdateNodegroupVersionRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateNodegroupVersion, request)
            def associateEncryptionConfig(
                request: AssociateEncryptionConfigRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly
            ] = proxy(AssociateEncryptionConfig, request)
            def describeCluster(request: DescribeClusterRequest): IO[
              AwsError,
              zio.aws.eks.model.DescribeClusterResponse.ReadOnly
            ] = proxy(DescribeCluster, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.eks.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listClusters(
                request: ListClustersRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListClusters, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listClustersPaginated(
                request: ListClustersRequest
            ): IO[AwsError, zio.aws.eks.model.ListClustersResponse.ReadOnly] =
              proxy(ListClustersPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.eks.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def updateAddon(
                request: UpdateAddonRequest
            ): IO[AwsError, zio.aws.eks.model.UpdateAddonResponse.ReadOnly] =
              proxy(UpdateAddon, request)
            def associateIdentityProviderConfig(
                request: AssociateIdentityProviderConfigRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly
            ] = proxy(AssociateIdentityProviderConfig, request)
            def deleteAddon(
                request: DeleteAddonRequest
            ): IO[AwsError, zio.aws.eks.model.DeleteAddonResponse.ReadOnly] =
              proxy(DeleteAddon, request)
            def describeNodegroup(request: DescribeNodegroupRequest): IO[
              AwsError,
              zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly
            ] = proxy(DescribeNodegroup, request)
            def createFargateProfile(request: CreateFargateProfileRequest): IO[
              AwsError,
              zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly
            ] = proxy(CreateFargateProfile, request)
            def updateClusterConfig(request: UpdateClusterConfigRequest): IO[
              AwsError,
              zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly
            ] = proxy(UpdateClusterConfig, request)
            def updateNodegroupConfig(
                request: UpdateNodegroupConfigRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.UpdateNodegroupConfigResponse.ReadOnly
            ] = proxy(UpdateNodegroupConfig, request)
            def listFargateProfiles(
                request: ListFargateProfilesRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFargateProfiles, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFargateProfilesPaginated(
                request: ListFargateProfilesRequest
            ): IO[
              AwsError,
              zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly
            ] = proxy(ListFargateProfilesPaginated, request)
            def listAddons(
                request: ListAddonsRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListAddons, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listAddonsPaginated(
                request: ListAddonsRequest
            ): IO[AwsError, zio.aws.eks.model.ListAddonsResponse.ReadOnly] =
              proxy(ListAddonsPaginated, request)
          }
        }
      }
    }
  }
}
