package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUpdateResponse(
    update: Optional[zio.aws.eks.model.Update] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeUpdateResponse = {
    import DescribeUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeUpdateResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeUpdateResponse.ReadOnly =
    zio.aws.eks.model.DescribeUpdateResponse.wrap(buildAwsValue())
}
object DescribeUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeUpdateResponse = zio.aws.eks.model
      .DescribeUpdateResponse(update.map(value => value.asEditable))
    def update: Optional[zio.aws.eks.model.Update.ReadOnly]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeUpdateResponse
  ) extends zio.aws.eks.model.DescribeUpdateResponse.ReadOnly {
    override val update: Optional[zio.aws.eks.model.Update.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.update())
        .map(value => zio.aws.eks.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeUpdateResponse
  ): zio.aws.eks.model.DescribeUpdateResponse.ReadOnly = new Wrapper(impl)
}
