package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Compatibility(
    clusterVersion: Optional[String] = Optional.Absent,
    platformVersions: Optional[Iterable[String]] = Optional.Absent,
    defaultVersion: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.Compatibility = {
    import Compatibility.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Compatibility
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        platformVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.platformVersions)
      .optionallyWith(defaultVersion.map(value => value: java.lang.Boolean))(
        _.defaultVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Compatibility.ReadOnly =
    zio.aws.eks.model.Compatibility.wrap(buildAwsValue())
}
object Compatibility {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Compatibility] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Compatibility =
      zio.aws.eks.model.Compatibility(
        clusterVersion.map(value => value),
        platformVersions.map(value => value),
        defaultVersion.map(value => value)
      )
    def clusterVersion: Optional[String]
    def platformVersions: Optional[List[String]]
    def defaultVersion: Optional[Boolean]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getPlatformVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("platformVersions", platformVersions)
    def getDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Compatibility
  ) extends zio.aws.eks.model.Compatibility.ReadOnly {
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val platformVersions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformVersions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val defaultVersion: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVersion())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Compatibility
  ): zio.aws.eks.model.Compatibility.ReadOnly = new Wrapper(impl)
}
