package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait AddonStatus {
  def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus
}
object AddonStatus {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.AddonStatus
  ): zio.aws.eks.model.AddonStatus = value match {
    case software.amazon.awssdk.services.eks.model.AddonStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.eks.model.AddonStatus.DEGRADED =>
      val r = DEGRADED
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.CREATING
  }
  case object ACTIVE extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.ACTIVE
  }
  case object CREATE_FAILED extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.CREATE_FAILED
  }
  case object UPDATING extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.UPDATING
  }
  case object DELETING extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.DELETING
  }
  case object DELETE_FAILED extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.DELETE_FAILED
  }
  case object DEGRADED extends zio.aws.eks.model.AddonStatus {
    override def unwrap: software.amazon.awssdk.services.eks.model.AddonStatus =
      software.amazon.awssdk.services.eks.model.AddonStatus.DEGRADED
  }
}
