package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNodegroupRequest(
    clusterName: String,
    nodegroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest = {
    import DeleteNodegroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodegroupName(nodegroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteNodegroupRequest.ReadOnly =
    zio.aws.eks.model.DeleteNodegroupRequest.wrap(buildAwsValue())
}
object DeleteNodegroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteNodegroupRequest =
      zio.aws.eks.model.DeleteNodegroupRequest(clusterName, nodegroupName)
    def clusterName: String
    def nodegroupName: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodegroupName: ZIO[Any, Nothing, String] = ZIO.succeed(nodegroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest
  ) extends zio.aws.eks.model.DeleteNodegroupRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodegroupName: String = impl.nodegroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest
  ): zio.aws.eks.model.DeleteNodegroupRequest.ReadOnly = new Wrapper(impl)
}
