package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListUpdatesResponse(
    updateIds: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListUpdatesResponse = {
    import ListUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListUpdatesResponse
      .builder()
      .optionallyWith(
        updateIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.updateIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListUpdatesResponse.ReadOnly =
    zio.aws.eks.model.ListUpdatesResponse.wrap(buildAwsValue())
}
object ListUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListUpdatesResponse =
      zio.aws.eks.model.ListUpdatesResponse(
        updateIds.map(value => value),
        nextToken.map(value => value)
      )
    def updateIds: Optional[List[String]]
    def nextToken: Optional[String]
    def getUpdateIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("updateIds", updateIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListUpdatesResponse
  ) extends zio.aws.eks.model.ListUpdatesResponse.ReadOnly {
    override val updateIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.updateIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListUpdatesResponse
  ): zio.aws.eks.model.ListUpdatesResponse.ReadOnly = new Wrapper(impl)
}
