package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFargateProfileResponse(
    fargateProfile: Optional[zio.aws.eks.model.FargateProfile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse = {
    import DeleteFargateProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse
      .builder()
      .optionallyWith(fargateProfile.map(value => value.buildAwsValue()))(
        _.fargateProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly =
    zio.aws.eks.model.DeleteFargateProfileResponse.wrap(buildAwsValue())
}
object DeleteFargateProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteFargateProfileResponse =
      zio.aws.eks.model.DeleteFargateProfileResponse(
        fargateProfile.map(value => value.asEditable)
      )
    def fargateProfile: Optional[zio.aws.eks.model.FargateProfile.ReadOnly]
    def getFargateProfile
        : ZIO[Any, AwsError, zio.aws.eks.model.FargateProfile.ReadOnly] =
      AwsError.unwrapOptionField("fargateProfile", fargateProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse
  ) extends zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly {
    override val fargateProfile
        : Optional[zio.aws.eks.model.FargateProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fargateProfile())
        .map(value => zio.aws.eks.model.FargateProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse
  ): zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly = new Wrapper(impl)
}
