package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterClusterResponse(
    cluster: Optional[zio.aws.eks.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeregisterClusterResponse = {
    import DeregisterClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeregisterClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeregisterClusterResponse.ReadOnly =
    zio.aws.eks.model.DeregisterClusterResponse.wrap(buildAwsValue())
}
object DeregisterClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeregisterClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeregisterClusterResponse =
      zio.aws.eks.model
        .DeregisterClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.eks.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeregisterClusterResponse
  ) extends zio.aws.eks.model.DeregisterClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.eks.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeregisterClusterResponse
  ): zio.aws.eks.model.DeregisterClusterResponse.ReadOnly = new Wrapper(impl)
}
