package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.eks.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListTagsForResourceRequest =
      zio.aws.eks.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: String
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest
  ) extends zio.aws.eks.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest
  ): zio.aws.eks.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
