package zio.aws.eks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ConnectorConfigResponse(
    activationId: Optional[String] = Optional.Absent,
    activationCode: Optional[String] = Optional.Absent,
    activationExpiry: Optional[Timestamp] = Optional.Absent,
    provider: Optional[String] = Optional.Absent,
    roleArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ConnectorConfigResponse = {
    import ConnectorConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
      .builder()
      .optionallyWith(activationId.map(value => value: java.lang.String))(
        _.activationId
      )
      .optionallyWith(activationCode.map(value => value: java.lang.String))(
        _.activationCode
      )
      .optionallyWith(
        activationExpiry.map(value => Timestamp.unwrap(value): Instant)
      )(_.activationExpiry)
      .optionallyWith(provider.map(value => value: java.lang.String))(
        _.provider
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ConnectorConfigResponse.ReadOnly =
    zio.aws.eks.model.ConnectorConfigResponse.wrap(buildAwsValue())
}
object ConnectorConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ConnectorConfigResponse =
      zio.aws.eks.model.ConnectorConfigResponse(
        activationId.map(value => value),
        activationCode.map(value => value),
        activationExpiry.map(value => value),
        provider.map(value => value),
        roleArn.map(value => value)
      )
    def activationId: Optional[String]
    def activationCode: Optional[String]
    def activationExpiry: Optional[Timestamp]
    def provider: Optional[String]
    def roleArn: Optional[String]
    def getActivationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getActivationCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activationCode", activationCode)
    def getActivationExpiry: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("activationExpiry", activationExpiry)
    def getProvider: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provider", provider)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
  ) extends zio.aws.eks.model.ConnectorConfigResponse.ReadOnly {
    override val activationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.activationId())
      .map(value => value: String)
    override val activationCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.activationCode())
      .map(value => value: String)
    override val activationExpiry: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.activationExpiry())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val provider: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value => value: String)
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
  ): zio.aws.eks.model.ConnectorConfigResponse.ReadOnly = new Wrapper(impl)
}
