package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateSpecification(
    name: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification = {
    import LaunchTemplateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly =
    zio.aws.eks.model.LaunchTemplateSpecification.wrap(buildAwsValue())
}
object LaunchTemplateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.LaunchTemplateSpecification =
      zio.aws.eks.model.LaunchTemplateSpecification(
        name.map(value => value),
        version.map(value => value),
        id.map(value => value)
      )
    def name: Optional[String]
    def version: Optional[String]
    def id: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification
  ) extends zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification
  ): zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly = new Wrapper(impl)
}
