package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey, ClusterName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    name: ClusterName,
    version: Optional[String] = Optional.Absent,
    roleArn: String,
    resourcesVpcConfig: zio.aws.eks.model.VpcConfigRequest,
    kubernetesNetworkConfig: Optional[
      zio.aws.eks.model.KubernetesNetworkConfigRequest
    ] = Optional.Absent,
    logging: Optional[zio.aws.eks.model.Logging] = Optional.Absent,
    clientRequestToken: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    encryptionConfig: Optional[Iterable[zio.aws.eks.model.EncryptionConfig]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateClusterRequest
      .builder()
      .name(ClusterName.unwrap(name): java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .roleArn(roleArn: java.lang.String)
      .resourcesVpcConfig(resourcesVpcConfig.buildAwsValue())
      .optionallyWith(
        kubernetesNetworkConfig.map(value => value.buildAwsValue())
      )(_.kubernetesNetworkConfig)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.encryptionConfig)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateClusterRequest.ReadOnly =
    zio.aws.eks.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateClusterRequest =
      zio.aws.eks.model.CreateClusterRequest(
        name,
        version.map(value => value),
        roleArn,
        resourcesVpcConfig.asEditable,
        kubernetesNetworkConfig.map(value => value.asEditable),
        logging.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        tags.map(value => value),
        encryptionConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ClusterName
    def version: Optional[String]
    def roleArn: String
    def resourcesVpcConfig: zio.aws.eks.model.VpcConfigRequest.ReadOnly
    def kubernetesNetworkConfig
        : Optional[zio.aws.eks.model.KubernetesNetworkConfigRequest.ReadOnly]
    def logging: Optional[zio.aws.eks.model.Logging.ReadOnly]
    def clientRequestToken: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def encryptionConfig
        : Optional[List[zio.aws.eks.model.EncryptionConfig.ReadOnly]]
    def getName: ZIO[Any, Nothing, ClusterName] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getResourcesVpcConfig
        : ZIO[Any, Nothing, zio.aws.eks.model.VpcConfigRequest.ReadOnly] =
      ZIO.succeed(resourcesVpcConfig)
    def getKubernetesNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.KubernetesNetworkConfigRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kubernetesNetworkConfig",
      kubernetesNetworkConfig
    )
    def getLogging: ZIO[Any, AwsError, zio.aws.eks.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfig: ZIO[Any, AwsError, List[
      zio.aws.eks.model.EncryptionConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateClusterRequest
  ) extends zio.aws.eks.model.CreateClusterRequest.ReadOnly {
    override val name: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.name())
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val roleArn: String = impl.roleArn(): String
    override val resourcesVpcConfig
        : zio.aws.eks.model.VpcConfigRequest.ReadOnly =
      zio.aws.eks.model.VpcConfigRequest.wrap(impl.resourcesVpcConfig())
    override val kubernetesNetworkConfig
        : Optional[zio.aws.eks.model.KubernetesNetworkConfigRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetesNetworkConfig())
        .map(value =>
          zio.aws.eks.model.KubernetesNetworkConfigRequest.wrap(value)
        )
    override val logging: Optional[zio.aws.eks.model.Logging.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logging())
        .map(value => zio.aws.eks.model.Logging.wrap(value))
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val encryptionConfig
        : Optional[List[zio.aws.eks.model.EncryptionConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.EncryptionConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateClusterRequest
  ): zio.aws.eks.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
