package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddonHealth(
    issues: Optional[Iterable[zio.aws.eks.model.AddonIssue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.AddonHealth = {
    import AddonHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AddonHealth
      .builder()
      .optionallyWith(
        issues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.issues)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AddonHealth.ReadOnly =
    zio.aws.eks.model.AddonHealth.wrap(buildAwsValue())
}
object AddonHealth {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.AddonHealth] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AddonHealth =
      zio.aws.eks.model.AddonHealth(
        issues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def issues: Optional[List[zio.aws.eks.model.AddonIssue.ReadOnly]]
    def getIssues
        : ZIO[Any, AwsError, List[zio.aws.eks.model.AddonIssue.ReadOnly]] =
      AwsError.unwrapOptionField("issues", issues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AddonHealth
  ) extends zio.aws.eks.model.AddonHealth.ReadOnly {
    override val issues: Optional[List[zio.aws.eks.model.AddonIssue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.AddonIssue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AddonHealth
  ): zio.aws.eks.model.AddonHealth.ReadOnly = new Wrapper(impl)
}
