package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoteAccessConfig(
    ec2SshKey: Optional[String] = Optional.Absent,
    sourceSecurityGroups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.RemoteAccessConfig = {
    import RemoteAccessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.RemoteAccessConfig
      .builder()
      .optionallyWith(ec2SshKey.map(value => value: java.lang.String))(
        _.ec2SshKey
      )
      .optionallyWith(
        sourceSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.RemoteAccessConfig.ReadOnly =
    zio.aws.eks.model.RemoteAccessConfig.wrap(buildAwsValue())
}
object RemoteAccessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.RemoteAccessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.RemoteAccessConfig =
      zio.aws.eks.model.RemoteAccessConfig(
        ec2SshKey.map(value => value),
        sourceSecurityGroups.map(value => value)
      )
    def ec2SshKey: Optional[String]
    def sourceSecurityGroups: Optional[List[String]]
    def getEc2SshKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SshKey", ec2SshKey)
    def getSourceSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceSecurityGroups", sourceSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.RemoteAccessConfig
  ) extends zio.aws.eks.model.RemoteAccessConfig.ReadOnly {
    override val ec2SshKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2SshKey())
      .map(value => value: String)
    override val sourceSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.RemoteAccessConfig
  ): zio.aws.eks.model.RemoteAccessConfig.ReadOnly = new Wrapper(impl)
}
