package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateIdentityProviderConfigRequest(
    clusterName: String,
    identityProviderConfig: zio.aws.eks.model.IdentityProviderConfig,
    clientRequestToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest = {
    import DisassociateIdentityProviderConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .identityProviderConfig(identityProviderConfig.buildAwsValue())
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.DisassociateIdentityProviderConfigRequest.ReadOnly =
    zio.aws.eks.model.DisassociateIdentityProviderConfigRequest
      .wrap(buildAwsValue())
}
object DisassociateIdentityProviderConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eks.model.DisassociateIdentityProviderConfigRequest =
      zio.aws.eks.model.DisassociateIdentityProviderConfigRequest(
        clusterName,
        identityProviderConfig.asEditable,
        clientRequestToken.map(value => value)
      )
    def clusterName: String
    def identityProviderConfig
        : zio.aws.eks.model.IdentityProviderConfig.ReadOnly
    def clientRequestToken: Optional[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getIdentityProviderConfig
        : ZIO[Any, Nothing, zio.aws.eks.model.IdentityProviderConfig.ReadOnly] =
      ZIO.succeed(identityProviderConfig)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest
  ) extends zio.aws.eks.model.DisassociateIdentityProviderConfigRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val identityProviderConfig
        : zio.aws.eks.model.IdentityProviderConfig.ReadOnly =
      zio.aws.eks.model.IdentityProviderConfig
        .wrap(impl.identityProviderConfig())
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest
  ): zio.aws.eks.model.DisassociateIdentityProviderConfigRequest.ReadOnly =
    new Wrapper(impl)
}
