package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey, ClusterName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterClusterRequest(
    name: ClusterName,
    connectorConfig: zio.aws.eks.model.ConnectorConfigRequest,
    clientRequestToken: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.RegisterClusterRequest = {
    import RegisterClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.RegisterClusterRequest
      .builder()
      .name(ClusterName.unwrap(name): java.lang.String)
      .connectorConfig(connectorConfig.buildAwsValue())
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.RegisterClusterRequest.ReadOnly =
    zio.aws.eks.model.RegisterClusterRequest.wrap(buildAwsValue())
}
object RegisterClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.RegisterClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.RegisterClusterRequest =
      zio.aws.eks.model.RegisterClusterRequest(
        name,
        connectorConfig.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value => value)
      )
    def name: ClusterName
    def connectorConfig: zio.aws.eks.model.ConnectorConfigRequest.ReadOnly
    def clientRequestToken: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, ClusterName] = ZIO.succeed(name)
    def getConnectorConfig
        : ZIO[Any, Nothing, zio.aws.eks.model.ConnectorConfigRequest.ReadOnly] =
      ZIO.succeed(connectorConfig)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.RegisterClusterRequest
  ) extends zio.aws.eks.model.RegisterClusterRequest.ReadOnly {
    override val name: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.name())
    override val connectorConfig
        : zio.aws.eks.model.ConnectorConfigRequest.ReadOnly =
      zio.aws.eks.model.ConnectorConfigRequest.wrap(impl.connectorConfig())
    override val clientRequestToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestToken())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.RegisterClusterRequest
  ): zio.aws.eks.model.RegisterClusterRequest.ReadOnly = new Wrapper(impl)
}
