package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeIdentityProviderConfigRequest(
    clusterName: String,
    identityProviderConfig: zio.aws.eks.model.IdentityProviderConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest = {
    import DescribeIdentityProviderConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .identityProviderConfig(identityProviderConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.DescribeIdentityProviderConfigRequest.ReadOnly =
    zio.aws.eks.model.DescribeIdentityProviderConfigRequest
      .wrap(buildAwsValue())
}
object DescribeIdentityProviderConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeIdentityProviderConfigRequest =
      zio.aws.eks.model.DescribeIdentityProviderConfigRequest(
        clusterName,
        identityProviderConfig.asEditable
      )
    def clusterName: String
    def identityProviderConfig
        : zio.aws.eks.model.IdentityProviderConfig.ReadOnly
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getIdentityProviderConfig
        : ZIO[Any, Nothing, zio.aws.eks.model.IdentityProviderConfig.ReadOnly] =
      ZIO.succeed(identityProviderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest
  ) extends zio.aws.eks.model.DescribeIdentityProviderConfigRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val identityProviderConfig
        : zio.aws.eks.model.IdentityProviderConfig.ReadOnly =
      zio.aws.eks.model.IdentityProviderConfig
        .wrap(impl.identityProviderConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest
  ): zio.aws.eks.model.DescribeIdentityProviderConfigRequest.ReadOnly =
    new Wrapper(impl)
}
