package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConnectorConfigRequest(
    roleArn: String,
    provider: zio.aws.eks.model.ConnectorConfigProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ConnectorConfigRequest = {
    import ConnectorConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ConnectorConfigRequest
      .builder()
      .roleArn(roleArn: java.lang.String)
      .provider(provider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ConnectorConfigRequest.ReadOnly =
    zio.aws.eks.model.ConnectorConfigRequest.wrap(buildAwsValue())
}
object ConnectorConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ConnectorConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ConnectorConfigRequest =
      zio.aws.eks.model.ConnectorConfigRequest(roleArn, provider)
    def roleArn: String
    def provider: zio.aws.eks.model.ConnectorConfigProvider
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.eks.model.ConnectorConfigProvider] =
      ZIO.succeed(provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ConnectorConfigRequest
  ) extends zio.aws.eks.model.ConnectorConfigRequest.ReadOnly {
    override val roleArn: String = impl.roleArn(): String
    override val provider: zio.aws.eks.model.ConnectorConfigProvider =
      zio.aws.eks.model.ConnectorConfigProvider.wrap(impl.provider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ConnectorConfigRequest
  ): zio.aws.eks.model.ConnectorConfigRequest.ReadOnly = new Wrapper(impl)
}
