package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAddonResponse(
    update: Optional[zio.aws.eks.model.Update] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateAddonResponse = {
    import UpdateAddonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateAddonResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateAddonResponse.ReadOnly =
    zio.aws.eks.model.UpdateAddonResponse.wrap(buildAwsValue())
}
object UpdateAddonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateAddonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateAddonResponse = zio.aws.eks.model
      .UpdateAddonResponse(update.map(value => value.asEditable))
    def update: Optional[zio.aws.eks.model.Update.ReadOnly]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateAddonResponse
  ) extends zio.aws.eks.model.UpdateAddonResponse.ReadOnly {
    override val update: Optional[zio.aws.eks.model.Update.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.update())
        .map(value => zio.aws.eks.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateAddonResponse
  ): zio.aws.eks.model.UpdateAddonResponse.ReadOnly = new Wrapper(impl)
}
