package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodegroupResources(
    autoScalingGroups: Optional[Iterable[zio.aws.eks.model.AutoScalingGroup]] =
      Optional.Absent,
    remoteAccessSecurityGroup: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.NodegroupResources = {
    import NodegroupResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.NodegroupResources
      .builder()
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        remoteAccessSecurityGroup.map(value => value: java.lang.String)
      )(_.remoteAccessSecurityGroup)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.NodegroupResources.ReadOnly =
    zio.aws.eks.model.NodegroupResources.wrap(buildAwsValue())
}
object NodegroupResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.NodegroupResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.NodegroupResources =
      zio.aws.eks.model.NodegroupResources(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remoteAccessSecurityGroup.map(value => value)
      )
    def autoScalingGroups
        : Optional[List[zio.aws.eks.model.AutoScalingGroup.ReadOnly]]
    def remoteAccessSecurityGroup: Optional[String]
    def getAutoScalingGroups: ZIO[Any, AwsError, List[
      zio.aws.eks.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getRemoteAccessSecurityGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("remoteAccessSecurityGroup", remoteAccessSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.NodegroupResources
  ) extends zio.aws.eks.model.NodegroupResources.ReadOnly {
    override val autoScalingGroups
        : Optional[List[zio.aws.eks.model.AutoScalingGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.AutoScalingGroup.wrap(item)
          }.toList
        )
    override val remoteAccessSecurityGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccessSecurityGroup())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.NodegroupResources
  ): zio.aws.eks.model.NodegroupResources.ReadOnly = new Wrapper(impl)
}
