package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{
  TagValue,
  TagKey,
  RequiredClaimsValue,
  RequiredClaimsKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OidcIdentityProviderConfig(
    identityProviderConfigName: Optional[String] = Optional.Absent,
    identityProviderConfigArn: Optional[String] = Optional.Absent,
    clusterName: Optional[String] = Optional.Absent,
    issuerUrl: Optional[String] = Optional.Absent,
    clientId: Optional[String] = Optional.Absent,
    usernameClaim: Optional[String] = Optional.Absent,
    usernamePrefix: Optional[String] = Optional.Absent,
    groupsClaim: Optional[String] = Optional.Absent,
    groupsPrefix: Optional[String] = Optional.Absent,
    requiredClaims: Optional[Map[RequiredClaimsKey, RequiredClaimsValue]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    status: Optional[zio.aws.eks.model.ConfigStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig = {
    import OidcIdentityProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
      .builder()
      .optionallyWith(
        identityProviderConfigName.map(value => value: java.lang.String)
      )(_.identityProviderConfigName)
      .optionallyWith(
        identityProviderConfigArn.map(value => value: java.lang.String)
      )(_.identityProviderConfigArn)
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(issuerUrl.map(value => value: java.lang.String))(
        _.issuerUrl
      )
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(usernameClaim.map(value => value: java.lang.String))(
        _.usernameClaim
      )
      .optionallyWith(usernamePrefix.map(value => value: java.lang.String))(
        _.usernamePrefix
      )
      .optionallyWith(groupsClaim.map(value => value: java.lang.String))(
        _.groupsClaim
      )
      .optionallyWith(groupsPrefix.map(value => value: java.lang.String))(
        _.groupsPrefix
      )
      .optionallyWith(
        requiredClaims.map(value =>
          value
            .map({ case (key, value) =>
              (RequiredClaimsKey.unwrap(
                key
              ): java.lang.String) -> (RequiredClaimsValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requiredClaims)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly =
    zio.aws.eks.model.OidcIdentityProviderConfig.wrap(buildAwsValue())
}
object OidcIdentityProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.OidcIdentityProviderConfig =
      zio.aws.eks.model.OidcIdentityProviderConfig(
        identityProviderConfigName.map(value => value),
        identityProviderConfigArn.map(value => value),
        clusterName.map(value => value),
        issuerUrl.map(value => value),
        clientId.map(value => value),
        usernameClaim.map(value => value),
        usernamePrefix.map(value => value),
        groupsClaim.map(value => value),
        groupsPrefix.map(value => value),
        requiredClaims.map(value => value),
        tags.map(value => value),
        status.map(value => value)
      )
    def identityProviderConfigName: Optional[String]
    def identityProviderConfigArn: Optional[String]
    def clusterName: Optional[String]
    def issuerUrl: Optional[String]
    def clientId: Optional[String]
    def usernameClaim: Optional[String]
    def usernamePrefix: Optional[String]
    def groupsClaim: Optional[String]
    def groupsPrefix: Optional[String]
    def requiredClaims: Optional[Map[RequiredClaimsKey, RequiredClaimsValue]]
    def tags: Optional[Map[TagKey, TagValue]]
    def status: Optional[zio.aws.eks.model.ConfigStatus]
    def getIdentityProviderConfigName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityProviderConfigName",
        identityProviderConfigName
      )
    def getIdentityProviderConfigArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("identityProviderConfigArn", identityProviderConfigArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getIssuerUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("issuerUrl", issuerUrl)
    def getClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getUsernameClaim: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usernameClaim", usernameClaim)
    def getUsernamePrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usernamePrefix", usernamePrefix)
    def getGroupsClaim: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupsClaim", groupsClaim)
    def getGroupsPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupsPrefix", groupsPrefix)
    def getRequiredClaims
        : ZIO[Any, AwsError, Map[RequiredClaimsKey, RequiredClaimsValue]] =
      AwsError.unwrapOptionField("requiredClaims", requiredClaims)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.ConfigStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
  ) extends zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly {
    override val identityProviderConfigName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderConfigName())
        .map(value => value: String)
    override val identityProviderConfigArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderConfigArn())
        .map(value => value: String)
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val issuerUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.issuerUrl())
      .map(value => value: String)
    override val clientId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => value: String)
    override val usernameClaim: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usernameClaim())
      .map(value => value: String)
    override val usernamePrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usernamePrefix())
      .map(value => value: String)
    override val groupsClaim: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupsClaim())
      .map(value => value: String)
    override val groupsPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupsPrefix())
      .map(value => value: String)
    override val requiredClaims
        : Optional[Map[RequiredClaimsKey, RequiredClaimsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredClaims())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eks.model.primitives.RequiredClaimsKey(
                key
              ) -> zio.aws.eks.model.primitives.RequiredClaimsValue(value)
            })
            .toMap
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val status: Optional[zio.aws.eks.model.ConfigStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.eks.model.ConfigStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfig
  ): zio.aws.eks.model.OidcIdentityProviderConfig.ReadOnly = new Wrapper(impl)
}
