package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddonInfo(
    addonName: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    addonVersions: Optional[Iterable[zio.aws.eks.model.AddonVersionInfo]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.AddonInfo = {
    import AddonInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AddonInfo
      .builder()
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(
        addonVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addonVersions)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AddonInfo.ReadOnly =
    zio.aws.eks.model.AddonInfo.wrap(buildAwsValue())
}
object AddonInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.AddonInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AddonInfo = zio.aws.eks.model.AddonInfo(
      addonName.map(value => value),
      `type`.map(value => value),
      addonVersions.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def addonName: Optional[String]
    def `type`: Optional[String]
    def addonVersions
        : Optional[List[zio.aws.eks.model.AddonVersionInfo.ReadOnly]]
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getAddonVersions: ZIO[Any, AwsError, List[
      zio.aws.eks.model.AddonVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("addonVersions", addonVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AddonInfo
  ) extends zio.aws.eks.model.AddonInfo.ReadOnly {
    override val addonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonName())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val addonVersions
        : Optional[List[zio.aws.eks.model.AddonVersionInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addonVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.AddonVersionInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AddonInfo
  ): zio.aws.eks.model.AddonInfo.ReadOnly = new Wrapper(impl)
}
