package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{ListAddonsRequestMaxResults, ClusterName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAddonsRequest(
    clusterName: ClusterName,
    maxResults: Optional[ListAddonsRequestMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListAddonsRequest = {
    import ListAddonsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListAddonsRequest
      .builder()
      .clusterName(ClusterName.unwrap(clusterName): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListAddonsRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListAddonsRequest.ReadOnly =
    zio.aws.eks.model.ListAddonsRequest.wrap(buildAwsValue())
}
object ListAddonsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListAddonsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListAddonsRequest =
      zio.aws.eks.model.ListAddonsRequest(
        clusterName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterName: ClusterName
    def maxResults: Optional[ListAddonsRequestMaxResults]
    def nextToken: Optional[String]
    def getClusterName: ZIO[Any, Nothing, ClusterName] =
      ZIO.succeed(clusterName)
    def getMaxResults: ZIO[Any, AwsError, ListAddonsRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListAddonsRequest
  ) extends zio.aws.eks.model.ListAddonsRequest.ReadOnly {
    override val clusterName: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.clusterName())
    override val maxResults: Optional[ListAddonsRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives.ListAddonsRequestMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListAddonsRequest
  ): zio.aws.eks.model.ListAddonsRequest.ReadOnly = new Wrapper(impl)
}
